/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.block;

import com.github.alexthe666.alexsmobs.entity.EntityGust;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockGustmaker
extends Block {
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.field_208197_x;

    public BlockGustmaker() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200943_b(4.5f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName("alexsmobs:gustmaker");
    }

    public static Vector3d getDispensePosition(BlockPos coords, Direction dir) {
        double d0 = (double)coords.func_177958_n() + 0.5 + 0.7 * (double)dir.func_82601_c();
        double d1 = (double)coords.func_177956_o() + 0.15 + 0.7 * (double)dir.func_96559_d();
        double d2 = (double)coords.func_177952_p() + 0.5 + 0.7 * (double)dir.func_82599_e();
        return new Vector3d(d0, d1, d2);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.tickGustmaker(state, worldIn, pos, false);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        this.tickGustmaker(state, (World)worldIn, pos, true);
    }

    public void tickGustmaker(BlockState state, World worldIn, BlockPos pos, boolean tickOff) {
        boolean flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(pos.func_177977_b()) || worldIn.func_175640_z(pos.func_177984_a());
        boolean flag1 = (Boolean)state.func_177229_b((Property)TRIGGERED);
        if (flag && !flag1) {
            Vector3d dispensePosition = BlockGustmaker.getDispensePosition(pos, (Direction)state.func_177229_b((Property)FACING));
            Vector3d gustDir = Vector3d.func_237491_b_((Vector3i)((Direction)state.func_177229_b((Property)FACING)).func_176730_m()).func_216372_d(0.1, 0.1, 0.1);
            EntityGust gust = new EntityGust(worldIn);
            gust.setGustDir((float)gustDir.field_72450_a, (float)gustDir.field_72448_b, (float)gustDir.field_72449_c);
            gust.func_70107_b(dispensePosition.field_72450_a, dispensePosition.field_72448_b, dispensePosition.field_72449_c);
            if (((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.Y) {
                gust.setVertical(true);
            }
            if (!worldIn.field_72995_K) {
                worldIn.func_217376_c((Entity)gust);
            }
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 2);
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 20);
        } else if (flag1 && tickOff) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 20);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, TRIGGERED});
    }
}

